<?php
ob_start();
require_once 'config.php';

setCorsHeaders();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    ob_end_clean();
    exit(json_encode(['error' => 'Method not allowed']));
}

$data = json_decode(file_get_contents('php://input'), true);
$email = filter_var($data['email'] ?? '', FILTER_SANITIZE_EMAIL);
$name = htmlspecialchars($data['name'] ?? '');
$provider = $data['provider'] ?? '';
$language = $data['language'] ?? 'nl';
$csrf_token = $data['csrf_token'] ?? '';

if (!$email || !$provider || !$csrf_token || !in_array($language, ['nl', 'fr', 'de']) || !in_array($provider, ['google', 'facebook'])) {
    http_response_code(400);
    ob_end_clean();
    exit(json_encode(['error' => 'Missing or invalid required fields']));
}

if (!validateCsrfToken($pdo, $csrf_token)) {
    http_response_code(403);
    ob_end_clean();
    exit(json_encode(['error' => 'Invalid CSRF token']));
}

$ip = getClientIp();
$rate_limit = checkRateLimit($pdo, $ip, $email);
if (isset($rate_limit['error'])) {
    http_response_code(429);
    ob_end_clean();
    exit(json_encode($rate_limit));
}

$stmt = $pdo->prepare('SELECT id FROM users WHERE email = ?');
$stmt->execute([$email]);
if ($stmt->fetch()) {
    http_response_code(409);
    ob_end_clean();
    exit(json_encode(['error' => 'User already exists']));
}

$stmt = $pdo->prepare('INSERT INTO users (email, name, provider, plan, language) VALUES (?, ?, ?, "free", ?)');
$stmt->execute([$email, $name, $provider, $language]);

deleteCsrfToken($pdo, $csrf_token);
$new_csrf_token = generateCsrfToken($pdo);
if (!$new_csrf_token) {
    http_response_code(500);
    ob_end_clean();
    exit(json_encode(['error' => 'Failed to generate new CSRF token']));
}

ob_end_clean();
echo json_encode(['success' => true, 'user_id' => $pdo->lastInsertId(), 'csrf_token' => $new_csrf_token]);
?>