<?php
ob_start();
require_once 'config.php';

setCorsHeaders();

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    ob_end_clean();
    exit(json_encode(['error' => 'Method not allowed']));
}

$ip = getClientIp();
$rate_limit = checkRateLimit($pdo, $ip);
if (isset($rate_limit['error'])) {
    http_response_code(429);
    ob_end_clean();
    exit(json_encode($rate_limit));
}

$csrf_token = generateCsrfToken($pdo);
if (!$csrf_token) {
    http_response_code(500);
    ob_end_clean();
    exit(json_encode(['error' => 'Failed to generate CSRF token']));
}

ob_end_clean();
echo json_encode(['success' => true, 'csrf_token' => $csrf_token]);
?>