<?php
require __DIR__ . '/SimpleXLSX.php';

use Shuchkin\SimpleXLSX;

try {
    $servername = "localhost";
    $username = "h67317c_admin";
    $password = "279308436Codingio#";
    $dbname = "h67317c_codingio";

    $conn = new mysqli($servername, $username, $password, $dbname);
    if ($conn->connect_error) {
        throw new Exception("Database connection failed: " . $conn->connect_error);
    }
    $filePath = __DIR__ ."/uploads/geek.xlsx";
    
    // Function to process the second file (SKU code, Shelf bin, Available qty)
    function processSecondFile($filePath, $conn) {
        if (!file_exists($filePath)) {
            throw new Exception("File not found: " . $filePath);
        }
        
        if ( $xlsx = SimpleXLSX::parse($filePath) ) {
    echo $xlsx->toHTML();
 } else {
    echo SimpleXLSX::parseError();
  }


        

        // Array to store the smallest Available qty for each SKU code
        $skuData = [];

        foreach ($rows as $index => $row) {
            if ($index === 0) continue; // Skip header row

            $sku = $conn->real_escape_string($row[0]); // SKU code
            $shelfbin = $conn->real_escape_string($row[1]); // Shelf bin
            $qty = (int)$row[2]; // Available qty

            // Only process rows with Available qty > 0
            if ($qty > 0) {
                // If SKU code already exists, keep the one with the smallest Available qty
                if (!isset($skuData[$sku]) || $qty < $skuData[$sku]['qty']) {
                    $skuData[$sku] = [
                        'shelfbin' => $shelfbin,
                        'qty' => $qty,
                    ];
                }
            }
        }

        // Insert data into the 'items' table
        foreach ($skuData as $sku => $data) {
            $shelfbin = $data['shelfbin'];
            $sql = "INSERT INTO items (item, shelfbin) 
                    SELECT '$sku', '$shelfbin' FROM DUAL 
                    WHERE NOT EXISTS (SELECT 1 FROM items WHERE item = '$sku')";
            if (!$conn->query($sql)) {
                throw new Exception("Error inserting data into items table: " . $conn->error);
            }
        }
    }
    $filePath = __DIR__ ."/uploads/geek.xlsx";
    // Function to process the first file (Item, Barcode)
    function processFirstFile($filePath, $conn) {
        if (!file_exists($filePath)) {
            throw new Exception("File not found: " . $filePath);
        }

            if ($xlsx = SimpleXLSX::parse($filePath)) {
                $rows = $xlsx->rows();
            } else {
                throw new Exception("Error reading XLSX file: " . SimpleXLSX::parseError());
            }
        

        foreach ($rows as $index => $row) {
            if ($index === 0) continue; // Skip header row

            $item = $conn->real_escape_string($row[0]); // Item
            $barcode = $conn->real_escape_string($row[2]); // Barcode

            // Insert data into the 'barcodes' table
            $sql = "INSERT INTO barcodes (item, barcode) 
                    SELECT '$item', '$barcode' FROM DUAL 
                    WHERE NOT EXISTS (SELECT 1 FROM barcodes WHERE barcode = '$barcode')";
            if (!$conn->query($sql)) {
                throw new Exception("Error inserting data into barcodes table: " . $conn->error);
            }
        }
    }

    // Process the second file first
    $_SESSION['progress'] = "Processing file 2 (SKU code, Shelf bin, Available qty)...";
    processSecondFile("uploads/" . basename($_FILES["file2"]["name"]), $conn);

    // Process the first file next
    $_SESSION['progress'] = "Processing file 1 (Item, Barcode)...";
    processFirstFile("uploads/" . basename($_FILES["file1"]["name"]), $conn);

    // Update the last_updated table
    $conn->query("UPDATE last_updated SET timestamp = NOW() WHERE id = 1");
    $_SESSION['progress'] = "Processing complete.";
} catch (Exception $e) {
    error_log("Error: " . $e->getMessage());
    echo "Error: " . $e->getMessage();
}
?>