<?php
require_once 'spout/src/Spout/Autoloader/autoload.php';
use Box\Spout\Reader\Common\Creator\ReaderEntityFactory;

try {
    $servername = "localhost";
    $username   = "h67317c_admin";
    $password   = "279308436Codingio#";
    $dbname     = "h67317c_codingio";

    $conn = new mysqli($servername, $username, $password, $dbname);
    if ($conn->connect_error) {
        throw new Exception("Database connection failed: " . $conn->connect_error);
    }
    echo "Database connected successfully.<br />";
    ob_flush();

    // Function to get column indexes using header names (ignoring case and extra spaces)
    function getColumnIndexes($headerRow, $requiredColumns) {
        // Normalize header row: trim and lowercase each header
        $normalizedHeaders = array_map(function($val) {
            return strtolower(trim($val));
        }, $headerRow);

        echo "Normalized Header Row: " . implode(", ", $normalizedHeaders) . "<br />";
        ob_flush();

        $indexes = [];
        foreach ($requiredColumns as $key => $colName) {
            $needle = strtolower(trim($colName));
            $index = array_search($needle, $normalizedHeaders);
            if ($index !== false) {
                $indexes[$key] = $index;
            }
        }
        echo "Found Column Indexes: " . print_r($indexes, true) . "<br />";
        ob_flush();

        if (count($indexes) !== count($requiredColumns)) {
            throw new Exception("Some required columns are missing! Expected: " . implode(", ", $requiredColumns));
        }
        return $indexes;
    }

    // Process the items file (second file) first.
    function processItemsFile($filePath, $conn) {
        echo "Processing items file: $filePath<br />";
        ob_flush();

        $reader = ReaderEntityFactory::createReaderFromFile($filePath);
        $reader->open($filePath);
        $skuMap = [];
        $columnIndexes = [];
        $headerFound = false;

        foreach ($reader->getSheetIterator() as $sheet) {
            foreach ($sheet->getRowIterator() as $rowIndex => $row) {
                $data = $row->toArray();
                // Look for header row if not already found.
                if (!$headerFound) {
                    try {
                        $columnIndexes = getColumnIndexes($data, [
                            'sku'      => 'SKU code',
                            'shelfbin' => 'Shelf bin',
                            'qty'      => 'Available qty'
                        ]);
                        echo "Header row found at row index: $rowIndex<br />";
                        ob_flush();
                        $headerFound = true;
                    } catch (Exception $e) {
                        echo "Header row not valid: " . $e->getMessage() . "<br />";
                        ob_flush();
                        continue; // Try next row
                    }
                    continue;
                }

                // Make sure our required indexes exist.
                if (!isset($columnIndexes['sku'], $columnIndexes['shelfbin'], $columnIndexes['qty'])) {
                    echo "ERROR: Missing column indexes. Skipping row.<br />";
                    ob_flush();
                    continue;
                }

                $sku     = $data[$columnIndexes['sku']] ?? null;
                $shelfbin= $data[$columnIndexes['shelfbin']] ?? null;
                $qty     = isset($data[$columnIndexes['qty']]) ? (int)$data[$columnIndexes['qty']] : null;

                if (!empty($sku) && !empty($shelfbin) && $qty > 0) {
                    // Keep the row with the lowest available quantity per SKU
                    if (!isset($skuMap[$sku]) || $qty < $skuMap[$sku]['qty']) {
                        $skuMap[$sku] = ['shelfbin' => $shelfbin, 'qty' => $qty];
                    }
                }
            }
        }
        $reader->close();

        echo "Finished processing items file. Inserting into database...<br />";
        ob_flush();

        foreach ($skuMap as $sku => $info) {
            $skuSafe     = $conn->real_escape_string($sku);
            $shelfbinSafe= $conn->real_escape_string($info['shelfbin']);
            $sql = "INSERT INTO items (item, shelfbin)
                    SELECT '$skuSafe', '$shelfbinSafe' FROM DUAL
                    WHERE NOT EXISTS (SELECT 1 FROM items WHERE item = '$skuSafe')";
            if ($conn->query($sql)) {
                echo "Inserted item: $skuSafe -> $shelfbinSafe<br />";
            } else {
                echo "Error inserting item: " . $conn->error . "<br />";
            }
            ob_flush();
        }
    }

    // Process the barcodes file (first file).
    function processBarcodesFile($filePath, $conn) {
        echo "<br />Processing barcodes file: $filePath<br />";
        ob_flush();

        $reader = ReaderEntityFactory::createReaderFromFile($filePath);
        $reader->open($filePath);
        $columnIndexes = [];
        $headerFound = false;
        $rowsProcessed = 0;

        foreach ($reader->getSheetIterator() as $sheet) {
            // Loop over rows in this sheet.
            foreach ($sheet->getRowIterator() as $rowIndex => $row) {
                $data = $row->toArray();
                echo "Row $rowIndex: " . print_r($data, true) . "<br />";
                ob_flush();

                if (!$headerFound) {
                    try {
                        $columnIndexes = getColumnIndexes($data, [
                            'item'    => 'Item',
                            'barcode' => 'Barcode'
                        ]);
                        echo "Header row found at row index: $rowIndex<br />";
                        ob_flush();
                        $headerFound = true;
                    } catch (Exception $e) {
                        echo "Header row not valid: " . $e->getMessage() . "<br />";
                        ob_flush();
                        continue; // Try next row
                    }
                    continue;
                }

                $rowsProcessed++;

                // Ensure the indexes exist.
                if (!isset($columnIndexes['item'], $columnIndexes['barcode'])) {
                    echo "ERROR: Missing column indexes. Skipping row.<br />";
                    ob_flush();
                    continue;
                }

                $item    = $data[$columnIndexes['item']] ?? null;
                $barcode = $data[$columnIndexes['barcode']] ?? null;

                if (!empty($item) && !empty($barcode)) {
                    $itemSafe    = $conn->real_escape_string($item);
                    $barcodeSafe = $conn->real_escape_string($barcode);

                    // Check if the item exists in the items table.
                    $checkItem = $conn->query("SELECT 1 FROM items WHERE item = '$itemSafe' LIMIT 1");
                    if ($checkItem && $checkItem->num_rows > 0) {
                        $sql = "INSERT INTO barcodes (item, barcode)
                                SELECT '$itemSafe', '$barcodeSafe' FROM DUAL
                                WHERE NOT EXISTS (SELECT 1 FROM barcodes WHERE barcode = '$barcodeSafe')";
                        if ($conn->query($sql)) {
                            echo "Inserted barcode: $itemSafe -> $barcodeSafe<br />";
                        } else {
                            echo "Error inserting barcode: " . $conn->error . "<br />";
                        }
                    } else {
                        echo "Skipped barcode (Item not found): $itemSafe -> $barcodeSafe<br />";
                    }
                    ob_flush();
                }
            }
        }
        $reader->close();
        if ($rowsProcessed == 0) {
            echo "No data rows processed in barcodes file.<br />";
        }
    }

    // Process the files.
    // (Adjust the file names if necessary)
    processItemsFile("uploads/geek.xlsx", $conn);
    processBarcodesFile("uploads/power.xlsx", $conn);

    echo "Processing completed.<br />";
    ob_flush();
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "<br />";
    ob_flush();
}
?>
