<?php
ini_set('max_execution_time', 300); // 300 seconds = 5 minutes
ini_set('memory_limit', '512M'); // Increase memory limit if needed

if (isset($_SESSION['processing']) && $_SESSION['processing'] === true) {
    die("Another file processing is in progress.");
}


if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (!isset($_SESSION['processing'])) {
        $_SESSION['processing'] = true;
        $_SESSION['progress'] = "Starting file processing...";

        try {
            $target_dir = "uploads/";
            if (!is_dir($target_dir)) {
                if (!mkdir($target_dir, 0777, true)) {
                    throw new Exception("Failed to create uploads directory.");
                }
            }

            $file1 = $target_dir . basename($_FILES["file1"]["name"]);
            $file2 = $target_dir . basename($_FILES["file2"]["name"]);

            if (move_uploaded_file($_FILES["file1"]["tmp_name"], $file1) && move_uploaded_file($_FILES["file2"]["tmp_name"], $file2)) {
                $_SESSION['progress'] = "Files uploaded, starting to parse...";

                // Include parse_files.php and catch any exceptions it throws
                try {
                    include 'parse_files.php';
                } catch (Exception $e) {
                    throw new Exception("Error in parse_files.php: " . $e->getMessage());
                }
            } else {
                throw new Exception("Failed to upload files.");
            }
        } catch (Exception $e) {
            $_SESSION['progress'] = "Error: " . $e->getMessage();
            unset($_SESSION['processing']); // Reset session on error
            error_log("Error in upload.php: " . $e->getMessage()); // Log the error
        }
    } else {
        echo "Another file processing is in progress.";
    }
}
?>