<?php
$servername = "localhost";
$username = "h67317c_admin";
$password = "279308436Codingio#";
$dbname = "h67317c_codingio";

header('Content-Type: application/json');

function respond($status, $message) {
    echo json_encode(array('status' => $status, 'message' => $message));
    exit();
}

// Create connection
$conn = new mysqli($servername, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    respond('error', "Connection failed: " . $conn->connect_error);
}

// Get the posted data
$data = json_decode(file_get_contents('php://input'), true);

if (!is_array($data)) {
    respond('error', 'Invalid data format');
}

$conn->autocommit(FALSE); // Turn off auto-commit to ensure atomic transactions

try {
    foreach ($data as $row) {
        if (!isset($row['item']) || !isset($row['shelfbins']) || !is_array($row['shelfbins']) || !isset($row['barcodes']) || !is_array($row['barcodes'])) {
            respond('error', 'Invalid row structure');
        }
        
        $item = $conn->real_escape_string($row['item']);
        $shelfbin = null;
        $minQty = PHP_INT_MAX;

        foreach ($row['shelfbins'] as $sb) {
            $current_shelfbin = $conn->real_escape_string($sb['shelfbin']);
            $availableQty = intval($sb['Available qty']);
            if ($current_shelfbin[0] !== 'T' && $availableQty > 0 && $availableQty < $minQty) {
                $shelfbin = $current_shelfbin;
                $minQty = $availableQty;
            }
        }
        
        if ($shelfbin === null) {
            // No valid shelfbin found
            $shelfbin = ''; // Or you can use a specific string to indicate non-existence
        }

        // Insert or update the item and shelfbin
        $sql = "INSERT INTO items (item, shelfbin) VALUES ('$item', '$shelfbin')
                ON DUPLICATE KEY UPDATE shelfbin=VALUES(shelfbin)";
        if (!$conn->query($sql)) {
            throw new Exception($conn->error);
        }

        // Insert the barcodes
        foreach ($row['barcodes'] as $barcode) {
            $barcode = $conn->real_escape_string($barcode);
            $sql = "INSERT INTO barcodes (item, barcode) VALUES ('$item', '$barcode')
                    ON DUPLICATE KEY UPDATE item=VALUES(item)";
            if (!$conn->query($sql)) {
                throw new Exception($conn->error);
            }
        }
    }

    // Update the last updated timestamp
    $update_sql = "UPDATE last_updated SET timestamp = NOW() WHERE id = 1";
    if (!$conn->query($update_sql)) {
        throw new Exception($conn->error);
    }

    $conn->commit(); // Commit the transaction
    respond('success', 'Data inserted/updated successfully');
} catch (Exception $e) {
    $conn->rollback(); // Rollback the transaction if any error occurs
    respond('error', $e->getMessage());
} finally {
    $conn->autocommit(TRUE); // Turn auto-commit back on
    $conn->close();
}
?>
