<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Token");
header("Access-Control-Max-Age: 86400");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Method not allowed']);
    exit;
}

$response = ['success' => false, 'data' => null, 'error' => null];

try {
    $uploadBaseDir = __DIR__ . '/uploads/screenshots/';
    if (!file_exists($uploadBaseDir)) mkdir($uploadBaseDir, 0777, true);
    if (!is_writable($uploadBaseDir)) throw new Exception('Upload base directory not writable');

    // Token authentication
    $expectedToken = 'your-secure-token'; // Replace with a strong, secret token
    $providedToken = $_SERVER['HTTP_X_TOKEN'] ?? '';
    if ($providedToken !== $expectedToken) {
        throw new Exception('Unauthorized request: Invalid token');
    }

    if (!isset($_FILES['image']) || $_FILES['image']['error'] !== UPLOAD_ERR_OK) {
        throw new Exception('No valid image uploaded');
    }

    $websiteId = $_POST['website_id'] ?? '';
    $sessionId = $_POST['session_id'] ?? '';
    $url = $_POST['url'] ?? '';
    $viewportWidth = (int)($_POST['viewport_width'] ?? 1200);
    $viewportHeight = (int)($_POST['viewport_height'] ?? 500);
    $timestamp = $_POST['timestamp'] ?? date('Y-m-d_H-i-s');
    $chunkIndex = (int)($_POST['chunk_index'] ?? 0);
    $totalChunks = (int)($_POST['total_chunks'] ?? 1);
    $elements = json_decode($_POST['elements'] ?? '[]', true);

    // Validate inputs
    if (empty($websiteId) || !preg_match('/^[a-zA-Z0-9-]+$/', $websiteId) || $chunkIndex < 0 || $totalChunks <= 0 || $viewportWidth <= 0 || $viewportHeight <= 0) {
        throw new Exception('Invalid input parameters');
    }

    $websiteDir = $uploadBaseDir . $websiteId . '/';
    if (!file_exists($websiteDir)) mkdir($websiteDir, 0777, true);
    if (!is_writable($websiteDir)) throw new Exception("Website directory not writable: $websiteDir");

    $sessionDir = $websiteDir . "$timestamp/";
    if (!file_exists($sessionDir)) mkdir($sessionDir, 0777, true);

    $imagePath = $sessionDir . "chunk$chunkIndex.png";
    if (!move_uploaded_file($_FILES['image']['tmp_name'], $imagePath)) {
        throw new Exception("Failed to save chunk $chunkIndex to: $imagePath");
    }

    // Update metadata
    $metadata = [
        'website_id' => $websiteId,
        'timestamp' => $timestamp,
        'url' => $url,
        'viewport_width' => $viewportWidth,
        'viewport_height' => $viewportHeight * $totalChunks,
        'elements' => $elements,
        'chunks' => $totalChunks
    ];
    file_put_contents($sessionDir . 'metadata.json', json_encode($metadata, JSON_PRETTY_PRINT));

    $response['success'] = true;
    $response['message'] = "Chunk $chunkIndex of $totalChunks stored";
} catch (Exception $e) {
    error_log("store_snapshot.php: " . $e->getMessage());
    $response['error'] = $e->getMessage();
}

echo json_encode($response);